#ifndef TOPOLOGICALSORT_H_
#define TOPOLOGICALSORT_H_

//
// Include the C standard library header file here
//

#include <stdio.h>

//
// Other header files are included here
//

#include "Stack.h"
 
//
// Define the data structure here
//

#define MAX_VERTEX_NUM 50				// Maximum number of vertices

// Edge (arc)
typedef struct EdgeNode 
{
	int vertex;							// Vertex field. That is, the index of the vertex in the vertex array.
	struct EdgeNode* nextedge;			// Chain domain. Point to the next Edge (arc).
}EdgeNode, *PEdgeList;

// vertex
typedef struct VexNode 
{
	// Use a string as the vertex's stored value. You can also think of it as the vertex's name.
	const char* name;					
	PEdgeList firstarc;	        		// Pointing to the first side arc.
	int Indegree;						// indegree of vertex.
}VexNode;

// Graph. Use adjacency list storage
typedef struct GraphList 
{
	VexNode vexlist[MAX_VERTEX_NUM];	// Vertex table
	int length;							// Vertex number
}GraphList;

//
// Declare the function here
//

void InitGraph(GraphList* pGraphList);
void FindInDegree(GraphList *pGraphList);
int TopoSort(GraphList *pGraphList);
void DeleteGraph(GraphList* pGraphList);
void OutputSortResult(GraphList *pGraphList);

//
// Declare global variables here
//

extern Stack stack;
extern int TopoSortResult[MAX_VERTEX_NUM];
extern int ResultLength;

#endif /* TOPOLOGICALSORT_H_ */
