#include "TopologicalSort.h"

Stack stack;

int main(int argc, char* argv[])
{
	GraphList Graphlist; // A graph used for topological sorting
	int i;
	
	//
	// Initialize the figure
	//
	InitGraph(&Graphlist);
	
	//
	// Call the InitStack function to initialize the stack
	//
	InitStack(&stack);

	//
	// Topological sort
	//
	TopoSort(&Graphlist);
		
	OutputSortResult(&Graphlist);
		
	//
	// Destruction of figure
	//
	DeleteGraph(&Graphlist);

	return 0;
}

/*
function:
	Find the degree of entry of all vertices in the graph

parameter:
	pGraphList -- Figure pointer
	
*/
void FindInDegree(GraphList *pGraphList)
{
	
	//
	// TODO: Add the code here
	//
		
}

/*
function:
	Topological sort

parameter:
	pGraphList -- Figure pointer
	
returned value:
	Returns 1 if the sort succeeds
	Returns 1 if the sort fails	
*/
int TopoSortResult[MAX_VERTEX_NUM]; 	// An array that stores sorted results (subscripts)
int ResultLength = 0;					// The length of the array that stores the sorted result (subscript)
int TopoSort(GraphList *pGraphList)     
{	
	EdgeNode* pEdgeNode;  				// Edge (arc) node pointer
	int i, k;			 			    // The cursor
		
	//
	// TODO: Add the code here
	//

	return 0;
}


/*
function:
	Initializes the graph's adjacency list with the given data

parameter:
	pGraphList -- Figure pointer
*/
typedef struct VertexArrayEntry {
	const char* name;				// Name of the vertices.NULL indicates the end of the vertex sequence.
	int VexIndex[MAX_VERTEX_NUM];	// The sequence of vertices adjacent to this vertex.-1 indicates the end of the sequence.
}VertexArrayEntry;
const VertexArrayEntry VertexArray[] = {
	{ "C1", {2, 1, 3, 11, -1}},
	{ "C2", {2, -1}			 },
	{ "C3", {7, 6, 4, -1}	 },
	{ "C4", {4, -1}			 },
	{ "C5", {6, -1}			 },
	{ "C6", {7, -1}			 },
	{ "C7", {-1}			 },
	{ "C8", {-1}			 },
	{ "C9", {10, 11, 9, -1}  },		
	{ "C10",{11, -1}		 },
	{ "C11",{5, -1}			 },
	{ "C12",{-1}			 },
	{ NULL 					 }	// End mark
};

void InitGraph(GraphList* pGraphList)
{
	int i, j;					// The cursor
	EdgeNode** pEdgeNodePtr;	// Pointer to a pointer to an edge (arc) node pointer
	
	//
	// Reset the length of the data in the graph
	//
	pGraphList->length = 0;
	
	//
	// Initializes the graph's adjacency list with the given data
	//
	for(i=0; i<MAX_VERTEX_NUM ;i++)
	{
		if(NULL == VertexArray[i].name) // Name of the vertices.NULL indicates the end of the vertex sequence.
			break;
			
		pGraphList->vexlist[i].name = VertexArray[i].name;
		
		pEdgeNodePtr = &pGraphList->vexlist[i].firstarc; // Pointer to vertex array (where pointer is initialized)
		for(j=0; j<MAX_VERTEX_NUM; j++)
		{
			if(-1 == VertexArray[i].VexIndex[j])
			{
				*pEdgeNodePtr = NULL;
				break;
			}
			
			*pEdgeNodePtr = (EdgeNode*)malloc(sizeof(EdgeNode));
			(*pEdgeNodePtr)->vertex = VertexArray[i].VexIndex[j];
			pEdgeNodePtr = &(*pEdgeNodePtr)->nextedge;
		}
		
		pGraphList->length++;
	}
}

/*
function:
	Destruction of figure

parameter:
	pGraphList -- Figure pointer
*/
void DeleteGraph(GraphList* pGraphList)
{
	int i;
	EdgeNode* pEdgeNode;
	
	for(i=0; i<pGraphList->length; i++)
	{
		while(pGraphList->vexlist[i].firstarc != NULL)
		{
			pEdgeNode = pGraphList->vexlist[i].firstarc;
			pGraphList->vexlist[i].firstarc = pEdgeNode->nextedge;
			free(pEdgeNode);
		}
	}
	
	pGraphList->length = 0;
}

void OutputSortResult(GraphList *pGraphList)
{
	int i;
	for(i = 0; i < ResultLength; i++)
	{
		printf("%d ", TopoSortResult[i]);
	}
	printf("\n");
}

