#ifndef SEQTABLE_H_
#define SEQTABLE_H_

//
// Include the C standard library header file here
//

#include <stdio.h>

//
// Other header files are included here
//

//
// Define the data structure here
//

// Elements in a linear table
typedef int KeyType;
typedef struct ElemType 
{
	KeyType key;	// Primary key
					// Omit other data and no longer define
}ElemType;

// The sequential storage structure of a linear table
typedef struct SeqTable 
{
	ElemType* elem;	// Data element storage space base address, 
					// allocated according to the actual length when the table is built,
					// Unit 0 is left blank and is used from unit 1.
	int length;		// The length of the table
}SeqTable;


//
// Declare the function here
//

int BinarySearch(SeqTable* pST, KeyType key);
void InitSeqTable(SeqTable* pST);
void DeleteSeqTable(SeqTable* pST);

//
// Declare global variables here
//

#endif /* SEQTABLE_H_ */
