#include "SeqTable.h"

int main(int argc, char* argv[])
{
	SeqTable ST;	// Linear table
	int i, pos1, pos2;
	
	//
	// Initialize the linear table
	//
	InitSeqTable(&ST);
	
	//
	// Binary search
	//
	pos1 = BinarySearch(&ST, 60);
	pos2 = BinarySearch(&ST, 30);	// To find the failure
	
	printf("%d %d\n", pos1, pos2);

	//
	// Destroy linear table
	//
	DeleteSeqTable(&ST);

	return 0;
}

/*
function:
	Binary search.

parameter:
	pST -- Linear table pointer
	key -- search key
  
returned value:
	Returns the position of the keyword in the table if the lookup is successful
	Returns 0 if the lookup fails
*/
int BinarySearch(SeqTable* pST, KeyType key)
{
	int low = 1;
	int high = pST->length;
	int mid;
	
	//
	// TODO: Add the code here
	//
	
	return 0;
}

/*
function:
	Initialize the linear table.

parameter:
	pST -- Linear table pointer
*/

//                  1, 2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12
// The order must be from smallest to largest
int InitArray[] = { 2, 4, 11, 18, 25, 32, 39, 46, 53, 60, 67, 74 };
void InitSeqTable(SeqTable* pST)
{
	int i;
	
	pST->length = sizeof(InitArray) / sizeof(InitArray[0]);
	// Because the 0 is left blank, the length must be increased by 1
	pST->elem = (ElemType*)malloc((pST->length + 1) * sizeof(ElemType));	
	
	for (i=1; i<=pST->length; i++)
	{
		pST->elem[i].key = InitArray[i-1];
	}
}

/*
function:
	Destroy linear table.

parameter:
	pST -- Linear table pointer
*/
void DeleteSeqTable(SeqTable* pST)
{
	free(pST->elem);
	
	pST->elem = NULL;
	pST->length = 0;
}
