#ifndef BINARYSEARCHTREE_H_
#define BINARYSEARCHTREE_H_

//
// Include the C standard library header file here
//

#include <stdio.h>

//
// Other header files are included here
//

#include <stdlib.h>

//
// Define the data structure here
//

typedef int KeyType;		// Key field type

typedef enum _TreeNodeType
{
	TREE_ROOT,		// root node
	TREE_LEFT,		// left child
	TREE_RIGHT		// right child
}TreeNodeType;

typedef struct BinSearchNode
{
	KeyType Key;						// The key field of the node
	struct BinSearchNode* lchild;		// Left child pointer
	struct BinSearchNode* rchild;		// Right child pointer
}BinSearchNode, *PBinSearchNode;

typedef struct BinSearchNodeExtra
{
	TreeNodeType enumType;	// The node type
	int	flag;				// The binary on which the tree is constructed
	int	nLevel;			// The node hierarchy in the binary tree. The root node is 1.
}BinSearchNodeExtra, *PBinSearchNodeExtra;

typedef struct BinSearchNodeEntry
{
	BinSearchNodeExtra nodeExtra;
	BinSearchNode node;
	
}BinSearchNodeEntry, *PBinSearchNodeEntry;

typedef struct BinSearchNode* PBinSearchTree; // Binary sort tree pointer

//
// Declare the function here
//

int Search(PBinSearchTree* pTree, KeyType Key, PBinSearchNode* position);
int CreateSearchTree(PBinSearchTree* pTree, KeyType* Key, int Length);
void DeleteTree(PBinSearchTree pTree);

int CopyNode(PBinSearchTree* pTree, int nLevel, TreeNodeType nodeType, int flag);

void OutputResult(PBinSearchTree* pTree);


//
// Declare global variables here
//


#endif /* BINARYSEARCHTREE_H_ */
