#include "BinarySearchTree.h"

BinSearchNodeEntry nodeArray[50];	// Binary sort tree node sequence
int count = 0;	// Nodal number

int main(int argc, char* argv[])
{
	PBinSearchTree pTree; // Initializes the binary sort tree pointer
	
	//
	// Initializes the key array
	//
	KeyType Key[] = {18, 73, 10, 10, 5, 4, 6, 99, 27, 41, 51, 45, 32, 25, 54};
	int Length = sizeof(Key)/sizeof(Key[0]);
	
	//
	// Construct a binary sort tree
	//
	CreateSearchTree(&pTree, Key, Length);

	//
	// output result
	//	
		
	OutputResult(&pTree);
		
	//
	// Destroy the binary sort tree
	//
	DeleteTree(pTree);
	
	return 0;
}

/*
function:
	Search the binary sort tree for nodes whose Key is the Key.

parameter:
	pTree -- Pointer to binary sort tree pointer.
	Key -- The key code.
	position -- Pointer type of the node pointer used to return the searched node pointer.
  
returned value:
	Returns 1 if a node with Key is found; otherwise returns 0 
*/
int Search(PBinSearchTree* pTree, KeyType Key, PBinSearchNode* position)
{

	//
	// TODO: Add the code here
	//
	
}

/*
function:
	Create a binary sort tree node.

parameter:
	Key -- The key code.
  
returned value:
	Binary sort tree node pointer.	
*/
BinSearchNode* CreateNode(KeyType Key)
{
	BinSearchNode* pNode = (PBinSearchNode)malloc(sizeof(BinSearchNode));
	
	pNode->Key = Key;
	pNode->lchild = NULL;
	pNode->rchild = NULL;
	
	return pNode;
}

/*
function:
	Construct a binary sort tree.

parameter:
	pTree -- Pointer to binary sort tree pointer.
	Key -- Key array
	Length -- The length of the array.
  
returned value:
	The construct returns 1 successfully
	Construction failure returns 0 
*/
int CreateSearchTree(PBinSearchTree* pTree, KeyType* Key, int Length)
{
	int i;						     // The cursor
	*pTree = NULL;				     // Initializes the binary sort tree pointer
	PBinSearchNode pNode, position;  // Binary sort tree node pointer
	
	
	//
	// TODO: Add the code here
	//
	
	return 0;
}

/*
function:
	Destroy the binary sort tree.

parameter:
	pTree -- Pointer to a binary sort tree.
  
returned value:
	nothing
*/
void DeleteTree(PBinSearchTree pTree)
{
	//
	// The sequential traversal algorithm is implemented by recursion
	//
	if (pTree != NULL)
	{	
		DeleteTree(pTree->lchild);
		DeleteTree(pTree->rchild);
		
		free(pTree);
	}
}

/*
function:
	Get the binary sort tree node.Use recursion to implement preorder traversal.

parameter:

	pTree -- Node address
	nLevel -- The hierarchy of nodes.The root node is 1.
	nodeType -- The node type
	flag -- The binary on which the tree is constructed

returned value:
	If the expression constructed from the address evaluates 
	successfully, return 1. Otherwise, return 0.
*/
int  CopyNode(PBinSearchTree *pTree, int nLevel, TreeNodeType nodeType, int flag)
{
	int temp1, temp2;
	int i;

	// The recursion ends here
	if (NULL == *pTree)
	{
		return 1;
	}
	i = count;
	nodeArray[i].node.Key = (*pTree)->Key;
	nodeArray[i].node.lchild = (*pTree)->lchild;
	nodeArray[i].node.rchild = (*pTree)->rchild;
	nodeArray[i].nodeExtra.enumType = nodeType;
	nodeArray[i].nodeExtra.nLevel = nLevel;
	nodeArray[i].nodeExtra.flag = flag;
	
	++count;
	
	temp2 = temp1 = flag;
	if (nodeType == TREE_ROOT)
	{
		temp1 = flag;
	}
	else if (flag == 0)
	{
		temp1 = nodeType == TREE_LEFT ? (flag + 1) << 1 : flag << 1;
	}
	else
	{
		temp1 = flag << 1;
	}

	temp2 = temp1;
	// Recursively compute left child and right child
	if (!CopyNode(&(nodeArray[i].node.lchild), nLevel + 1, TREE_LEFT, temp1))
	{
		return 0;
	}
	
	if (!CopyNode(&(nodeArray[i].node.rchild), nLevel + 1, TREE_RIGHT, temp2))
	{
		return 0;
	}

	return 1;
}

/*
function:
	output result.

parameter:
	pTree -- Pointer to a binary sort tree.
  
returned value:
	nothing
*/

void OutputResult(PBinSearchTree* pTree)
{
	int i, flag, deep, j;
	if (CopyNode(pTree, 1, TREE_ROOT, 0) == 0)
	{
		printf("Binary sort tree construct failed\n");
		return;
	}
	
	for (i = 0; i < count; i++)
	{
		flag = nodeArray[i].nodeExtra.flag;
		deep = nodeArray[i].nodeExtra.nLevel - 1;
		

		for (j=deep-1; j>0; j--)
		{
			if (flag & (1 << j))
			{
				printf(" |   ");
			}
			else if (deep > 1)
			{
				printf("     ");
			}
		}
		if (deep > 0)
		{
			printf(" +---");
		}
		
		printf("%2d ", nodeArray[i].node.Key);
		switch (nodeArray[i].nodeExtra.enumType)
		{
		case TREE_LEFT:
			printf("-L");
			break;
		case TREE_RIGHT:
			printf("-R");
			break;
		case TREE_ROOT:
		default:
			break;
		}	
		printf("\n");
	}
}


