# 目录
[概述](#概述)  
[数据结构实验](#数据该结构实验)  
[参考文献](#参考文献)  

# 概述
本教程可以用于数据结构析的实验课程。  
请读者`务必先阅读` [DS Lab使用手册](app-manual.md)，然后再按照下面的内容完成实验。  

# 数据结构实验

数据结构实验提供了28个实验题目，主要包含28个实验模板，涵盖了线性表、链表、二叉树、图、查找、排序等重要的知识点。在每个实验题目下面包含了相应的实验模板，每个模板可以有针对性的对知识点进行练习，通过使用这些模板根据题目的要求完成实验，就可以对数据结构中的绝大部分的知识进行强化。通过完成这些实验，可以提高编程水平，对以后从事相关方面的研发有很大的帮助作用。  

## 实验题目清单
[实验1 实验环境的使用](#实验1-实验环境的使用)  
[实验2 线性表的顺序表示及插入操作](#实验2-线性表的顺序表示及插入操作)  
[实验3 线性表的顺序表示及删除操作](#实验3-线性表的顺序表示及删除操作)  
[实验4 单链表的插入操作](#实验4-单链表的插入操作)  
[实验5 单链表的删除操作](#实验5-单链表的删除操作)  
[实验6 双向循环链表的插入操作](#实验6-双向循环链表的插入操作)  
[实验7 双向循环链表的删除操作](#实验7-双向循环链表的删除操)  
[实验8 字符串的顺序表示及插入操作](#实验8-字符串的顺序表示及插入操作)  
[实验9 二叉树的先序遍历操作](#实验9-二叉树的先序遍历操作)  
[实验10 二叉树的中序遍历操作](#实验10-二叉树的中序遍历操作)  
[实验11 二叉树的后序遍历操作](#实验11-二叉树的后序遍历操作)  
[实验12 线索二叉树](#实验12-线索二叉树)  
[实验13 赫夫曼树的构造](#实验13-赫夫曼树的构造)  
[实验14 一般树的遍历](#实验14-一般树的遍历)  
[实验15 图的深度优先搜索](#实验15-图的深度优先搜索)  
[实验16 图的广度优先搜索](#实验16-图的广度优先搜索)  
[实验17 拓扑排序](#实验17-拓扑排序)  
[实验18 关键路径](#实验18-关键路径)  
[实验19 最短路径（迪杰斯特拉算法）](#实验19-最短路径（迪杰斯特拉算法）)  
[实验20 最短路径（弗洛伊德算法）](#实验20-最短路径（弗洛伊德算法）)  
[实验21 折半查找](#实验21-折半查找)  
[实验22 二叉排序树的构造](#实验22-二叉排序树的构造)  
[实验23 创建哈希表（线性探测再散列）](#实验23-创建哈希表（线性探测再散列）)  
[实验24 创建哈希表（二次探测再散列）](#实验24-创建哈希表（二次探测再散列）)  
[实验25 创建哈希表（伪随机探测再散列）](#实验25-创建哈希表（伪随机探测再散列）)  
[实验26 冒泡排序](#实验26-冒泡排序)  
[实验27 快速排序](#实验27-快速排序)  
[实验28 堆排序](#实验28-堆排序)

## 实验1 实验环境的使用
建议学时：1学时

**`实验目的`**

- 熟悉数据结构集成实验环境DS Lab的基本使用方法。   
- 掌握线性表的顺序表示。
- 实现线性表的插入操作。


**`实验任务`**  

如果是第一次使用DS Lab完成实验，请先阅读[使用手册](./app-manual.md)，这样读者可以学习DS Lab的使用方法，后面的实验按照使用手册供的实验步骤就可以顺利完成。  

按照以下实验模板readme文件中的要求完成实验  
[Lab001](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab001.git) 在[使用手册](./app-manual.md)中有详细的步骤引导读者完成实验。  


## 实验2 线性表的顺序表示及插入操作  
建议学时：1学时

**`实验目的`**  
- 掌握线性表的顺序表示。
- 实现线性表的插入操作。

**`实验任务`**  

按照以下实验模板readme文件中的要求完成实验  
[Lab002](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab002.git)  

## 实验3 线性表的顺序表示及删除操作  
建议学时：1学时

**`实验目的`**  
- 掌握线性表的顺序表示。
- 实现线性表的删除操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验   
[Lab003](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab003.git)  

## 实验4 单链表的插入操作  
建议学时：1学时

**`实验目的`**  
- 掌握线性表的链式表示。
- 实现单链表的插入操作。

**`实验任务`**

按照以下实验模板readme文件中的要求完成实验  
[Lab004](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab004.git)  

## 实验5 单链表的删除操作  
建议学时：1学时

**`实验目的`**  
- 掌握线性表的链式表示。
- 实现单链表的删除操作。



**`实验任务`**

按照以下实验模板readme文件中的要求完成实验   
[Lab005](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab005.git)  

## 实验6 双向循环链表的插入操作
建议学时：1学时

**`实验目的`**  
- 掌握线性表的链式表示。
- 实现双向循环链表的插入操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验  
[Lab006](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab006.git)  


## 实验7 双向循环链表的删除操作
建议学时：1学时

**`实验目的`**  
- 掌握线性表的链式表示。
- 实现双向循环链表的删除操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验  
[Lab007](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab007.git)  
  
## 实验8 字符串的顺序表示及插入操作
建议学时：1学时

**`实验目的`**   
- 掌握字符串的顺序表示。
- 实现字符串的插入操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab008](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab008.git)  

## 实验9 二叉树的先序遍历操作
建议学时：1学时

**`实验目的`**  
- 掌握二叉树的链式存储结构。
- 实现二叉树的先序遍历操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验   
[Lab009](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab009.git)  

## 实验10 二叉树的中序遍历操作
建议学时：1学时

**`实验目的`**  
- 掌握二叉树的链式存储结构。
- 实现二叉树的中序遍历操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验   
[Lab010](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab010.git)  

## 实验11 二叉树的后序遍历操作
建议学时：1学时

**`实验目的`**   
- 掌握二叉树的链式存储结构。
- 实现二叉树的后序遍历操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验   
[Lab011](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab011.git)  

## 实验12 线索二叉树
建议学时：1学时

**`实验目的`**   
- 掌握线索二叉树的链式存储结构。
- 实现二叉树的中序线索化。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验   
[Lab012](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab012.git)  

## 实验13 赫夫曼树的构造
建议学时：1学时

**`实验目的`**   
- 掌握赫夫曼树的存储结构。
- 实现赫夫曼树的构造过程。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验   
[Lab013](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab013.git)  

## 实验14 一般树的遍历
建议学时：1学时  

**`实验目的`**   
- 掌握一般树的二叉链表表示法。
- 实现一般树的先序遍历算法。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab014](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab014.git)  
   
## 实验15 图的深度优先搜索
建议学时：1学时  

**`实验目的`**    
- 掌握图的邻接表存储结构。
- 实现图的深度优先搜索。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab015](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab015.git) 

## 实验16 图的广度优先搜索
建议学时：1学时  

**`实验目的`**   
- 掌握图的邻接表存储结构。
- 实现图的广度优先搜索。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab016](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab016.git) 

## 实验17 拓扑排序 
建议学时：1学时  

**`实验目的`**   
- 掌握图的邻接表存储结构。
- 实现图的拓扑排序操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab017](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab017.git) 

## 实验18 关键路径 
建议学时：1学时  

**`实验目的`**   
- 掌握图的邻接表存储结构。
- 实现图的关键路径查找操作。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab018](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab018.git) 

## 实验19 最短路径（迪杰斯特拉算法）
建议学时：1学时  

**`实验目的`**   
- 掌握图的邻接矩阵存储结构。
- 实现图的最短路径查找操作（迪杰斯特拉算法）。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab019](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab019.git) 

## 实验20 最短路径（弗洛伊德算法） 
建议学时：1学时  

**`实验目的`**   
- 掌握图的邻接矩阵存储结构。
- 实现图的最短路径查找操作（弗洛伊德算法）。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab020](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab020.git) 

## 实验21 折半查找
建议学时：1学时  

**`实验目的`**   
- 实现折半查找算法。

**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab021](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab021.git) 

## 实验22 二叉排序树的构造
建议学时：1学时  

**`实验目的`**   
- 掌握二叉排序树的链式存储结构。
- 实现二叉排序树的构造。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab022](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab022.git) 

## 实验23 创建哈希表（线性探测再散列）
建议学时：1学时  

**`实验目的`**   
- 实现哈希表的创建。
- 利用线性探测再散列处理冲突。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab023](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab023.git) 

## 实验24 创建哈希表（二次探测再散列）
建议学时：1学时  

**`实验目的`**   
- 实现哈希表的创建。
- 利用二次探测再散列处理冲突。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab024](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab024.git) 

## 实验25 创建哈希表（伪随机探测再散列）
建议学时：1学时  

**`实验目的`**   
- 实现哈希表的创建。
- 利用伪随机探测再散列处理冲突。


**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab025](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab025.git) 

## 实验26 冒泡排序
建议学时：1学时  

**`实验目的`**   
- 实现冒泡排序算法。

**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab026](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab026.git) 

## 实验27 快速排序
建议学时：1学时  

**`实验目的`**   
- 实现快速排序算法。

**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab027](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab027.git) 

## 实验28 堆排序
建议学时：1学时  

**`实验目的`**   
- 实现堆排序算法。

**`实验任务`**

按照以下实验模板readme文件中的要求完成实验    
[Lab028](https://www.codecode.net/engintime/ds-lab/Project-Template/Lab028.git) 


# 参考文献

[1]   张乃孝编著．算法与数据结构——C语言描述（第3版）．北京：高等教育出版社，2011   
[2]   严蔚敏编著．数据结构（C语言版）．北京：清华大学出版社，2007   
[3]   唐宁九，游洪跃等编著．数据结构与算法教程（C++版）实验和课程设计．北京：清华大学出版社，2012
 