/* ̨Ӧóڵ */

#include <stdio.h>

#define PHYSICAL_BLOCK_SIZE 1024
#define LOGICAL_BLOCK_SIZE 1024
#define NAME_LEN 14
#define START_PARTITION_TABLE 0x1be


//ṹ
struct par_table_entry {
	char boot_indicator;	//ָʾ0
	char start_chs_val[3];	//ʼͷֵ3ֽڷֱӦšͷš
	char par_type;			//
	char end_chs_val[3];	//ֹͷֵ
	int start_sector;		//ʼ̿
	int par_size;			//С
};

// ṹ
struct super_block
{
  unsigned short s_ninodes;		// ڵ
  unsigned short s_nzones;		// ߼
  unsigned short s_imap_blocks;	// i ڵλͼռõݿ
  unsigned short s_zmap_blocks;	// ߼λͼռõݿ
  unsigned short s_firstdatazone;	// һ߼š
  unsigned short s_log_zone_size;	// log(ݿ/߼)2 Ϊף
  unsigned long s_max_size;		// ļ󳤶ȡ
  unsigned short s_magic;		// ļϵͳħ
};

// iڵṹ
struct d_inode
{
  unsigned short i_mode;		// ļͺ(rwx λ)
  unsigned short i_uid;			// ûidļӵ߱ʶ
  unsigned long i_size;			// ļСֽ
  unsigned long i_time;			// ޸ʱ䣨1970.1.1:0 룩
  unsigned char i_gid;			// id(ļӵڵ)
  unsigned char i_nlinks;		// ٸļĿ¼ָi ڵ㣩
  unsigned short i_zone[9];		// ֱ(0-6)(7)˫ؼ(8)߼š
								// zone ˼Σ߼顣
};

//Ŀ¼ṹ
struct dir_entry{
	unsigned short inode;	//iڵ
	char name[NAME_LEN];	//ļ
};

struct super_block sblock;		//
struct par_table_entry pte[4];	//
FILE* fd;						//ļָ
char physical_block[PHYSICAL_BLOCK_SIZE]; //洢
char logical_block[LOGICAL_BLOCK_SIZE];  //洢߼
char *inode_bitmap;		//iڵλͼָ
//char *logical_bitmap;	//߼λͼָ,ʵδʹ

//ȡһ
void get_physical_block(int block_num)
{
	//1Ϊ̿Ǵ1ʼ
	fseek(fd, (block_num - 1) * PHYSICAL_BLOCK_SIZE, SEEK_SET);
	fread(physical_block, PHYSICAL_BLOCK_SIZE, 1, fd);
}

//ȡһһ߼
void get_partition_logical_block(int block_num)
{
	//block_numǰӵ1ʾڵһǰһ¼MBR飬
	//ӵ1Ϊ̿Ǵ1ʼ,߼Ǵ0ʼ
	get_physical_block(1 + block_num + 1);
	memcpy(logical_block, physical_block, LOGICAL_BLOCK_SIZE);
}

//ȡ
void get_partition_table()
{
	int i = 0;

	//416ֽڵıɣһʼַΪSTART_PARTITION_TABLE
	get_physical_block( 1 );	//̿ĵ1
	memcpy(pte, &physical_block[START_PARTITION_TABLE], sizeof(pte));
	for(i = 0; i < 4; i++)
	{
		printf("**************pattition table%d****************\n", i+1);
		printf("Boot Indicator:%d\n", pte[i].boot_indicator);
		printf("start CHS value:0x%04x\n", pte[i].start_chs_val);
		printf("partition type:%ld\n", pte[i].par_type);
		printf("end CHS value:0x%04x\n", pte[i].end_chs_val);
		printf("start sector:%d\n", pte[i].start_sector);
		printf("partition size:%d\n", pte[i].par_size);
	}
}

//ȡһĳ
void get_super_block()
{	
	get_partition_logical_block( 1 );
	memcpy(&sblock, logical_block, sizeof(sblock));
	
	printf("**************super block****************\n");
	printf("ninodes%d\n", sblock.s_ninodes);
	printf("nzones%d\n", sblock.s_nzones);
	printf("imap_blocks%d\n", sblock.s_imap_blocks);
	printf("zmap_blocks%d\n", sblock.s_zmap_blocks);
	printf("firstdatazone0x%04x\n", sblock.s_firstdatazone);
	printf("log_zone_size%d\n", sblock.s_log_zone_size);
	printf("max_size0x%x = %dByte\n", sblock.s_max_size,sblock.s_max_size);
	printf("magic0x%x\n", sblock.s_magic);
}	


//iڵλͼ
void load_inode_bitmap()
{
	inode_bitmap = (char*)malloc(sblock.s_imap_blocks * LOGICAL_BLOCK_SIZE);
	int i = 0;
	for(i = 0; i < sblock.s_imap_blocks; i++)
	{
		//iڵλͼǰ1һ
		get_partition_logical_block(1 + 1 + i);	
		memcpy(&inode_bitmap[i * LOGICAL_BLOCK_SIZE], &logical_block, LOGICAL_BLOCK_SIZE);
	}
}

//iڵλͼжӦiڵǷЧ
//inode_idΪiڵid
//Ч1Ч0
int is_inode_valid(unsigned short inode_id)
{
	if(inode_id > sblock.s_ninodes)
		return 0;
		
	char byte = inode_bitmap[(inode_id - 1) / 8]; //inode_id1ΪiڵǴ1ʼ
	return (byte >> (7 - (inode_id - 1) % 8) ) & 0x1;	//ȡһֽеĳλ1λ
}

//iڵidȡiڵ
void get_inode(unsigned short inode_id, struct d_inode* inode)
{
	//һ飬һ飬sblock.s_imap_blocksiڵλͼsblock.s_zmap_blocks߼λͼ	
	//һiڵռ32ֽڣһ̿LOGICAL_BLOCK_SIZE/32ڵ㣬inode_id/(LOGICAL_BLOCK_SIZE/32)
	//1ΪiڵǴ1ʼģ߼Ǵ0ʼ
	//inode_blocknumiڵ߼еƫƿ
	int inode_blocknum = 1 + 1 + sblock.s_imap_blocks + sblock.s_zmap_blocks + (inode_id - 1) / (LOGICAL_BLOCK_SIZE/32) ;
	get_partition_logical_block(inode_blocknum);
	memcpy((char*)inode, &logical_block[((inode_id - 1) % sizeof(struct d_inode)) * sizeof(struct d_inode)], sizeof(struct d_inode));
}

//ݹӡiڵµĿ¼
void print_inode(unsigned short id, int tab_count, const char* name)
{
	int i, m, n;
	struct d_inode inode;
	struct dir_entry dir;
	
	//iڵŶӦiڵλͼӦλֵΪ1,˵iڵʹ
	//˵iڵûѱɾֱӷ
	if(is_inode_valid(id) != 1)
		return;
		
	get_inode(id, &inode);
	tab_count++;
	unsigned short mode = inode.i_mode >> 12; //4λŵļ
	
	//Ŀ¼ļ
	if(mode == 4)
	{
		//ӡtabΪʹĿ¼вθ
		for(i=0; i<tab_count; i++)
		{
			printf("\t");
		}
		printf("%s\n", name);
		
		//ѭȡiڵеi_zones[]
		for(m = 0; m<7; m++)
		{
			//Ϊ0
			if(inode.i_zone[m] == 0)
				continue;
			
			//һ߼洢64Ŀ¼,ѭȡ64Ŀ¼
			//ǰֱΪ .  .. 
			for(n = 0; n < 64; n++)
			{
				get_partition_logical_block(inode.i_zone[m]);
				//߼еݿĿ¼ṹ
				memcpy((char*)&dir, &logical_block[n * sizeof(dir)], sizeof(dir));
				
				// ...ѭ
				if(n == 0 || n == 1)
					continue;
					
				//Ŀ¼ûٶȡ
				if(dir.inode == 0)
					break;
				
				//ݹӡĿ¼
				print_inode(dir.inode, tab_count, dir.name);
			}
		}
	}
	
	//ǳļ
	else if(mode == 8)
	{
		for(i=0; i<tab_count; i++)
		{
			printf("\t");
		}
		printf("%s\n", name);
	}
	//豸ļַ豸ļļ߳Լʵ
}


int main(int argc, char* argv[])
{
	int bit;
	struct d_inode* inode = (struct d_inode*)malloc(sizeof(struct d_inode));
	
	char* path = "harddisk.img";
	fd = fopen(path, "rb");
	if(fd==NULL)
		printf("open file failed!\n");
		
	//ȡ
	get_partition_table();
	//ȡ
	get_super_block();
	
	//iڵ߼λͼ
	load_inode_bitmap();
	//iڵλͼĵһλӦļϵͳĸڵ
	//һλΪ1ӡڵ
	bit = is_inode_valid(1);
	if(bit == 1)
		print_inode(1, -1, "\\");
	else
		printf("root node lost\n");
	
	return 0;
}
